/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryActivityRelationDao;
import cn.com.duiba.activity.center.biz.service.rob.RobActivityService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RobActivityServiceImpl
implements RobActivityService {
    @Autowired
    private RobCategoryActivityRelationDao robCategoryActivityRelationDao;

    @Override
    @Transactional(value="creditsActivity")
    public Boolean insertTodayRobActivity(Long activityId, List<Long> categoryIdList) {
        if (!CollectionUtils.isEmpty(categoryIdList)) {
            for (Long categoryId : categoryIdList) {
                this.robCategoryActivityRelationDao.insertRobCategoryActivityRelation(categoryId, activityId, 0);
            }
        }
        return true;
    }

    @Override
    public List<Long> getCategoryIdsByActivityId(Long activityId) {
        List<Long> categoryIds = this.robCategoryActivityRelationDao.getCategoryIdsByActivityId(activityId);
        if (categoryIds == null) {
            categoryIds = new ArrayList<Long>();
        }
        return categoryIds;
    }

    @Override
    public Boolean deleteRobCategoryActivityRelation(Long activityId, List<Long> categoryIdList) {
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return false;
        }
        for (Long categoryId : categoryIdList) {
            this.robCategoryActivityRelationDao.deleteByActivityIdAndCategoryId(activityId, categoryId);
        }
        return true;
    }
}

