/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobConfigDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryActivityRelationDao;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TodayRobConfigServiceImpl
implements TodayRobConfigService {
    @Autowired
    private TodayRobConfigDao todayRobConfigDao;
    @Autowired
    private RobCategoryActivityRelationDao robCategoryActivityRelationDao;

    @Override
    public TodayRobConfigDto find(Long configId) {
        return this.todayRobConfigDao.find(configId);
    }

    @Override
    public Long saveOrUpdateTodayRobConfig(TodayRobConfigDto todayRobConfigDto) {
        if (todayRobConfigDto.getId() != null) {
            this.todayRobConfigDao.update(todayRobConfigDto);
            return todayRobConfigDto.getId();
        }
        return (long)this.todayRobConfigDao.insert(todayRobConfigDto);
    }

    @Override
    public List<TodayRobConfigDto> findTodayRobConfigPage(Map<String, Object> params) {
        return this.todayRobConfigDao.findTodayRobConfigPage(params);
    }

    @Override
    public Integer findTodayRobConfigCount(Map<String, Object> params) {
        return this.todayRobConfigDao.findTodayRobConfigCount(params);
    }

    @Override
    public Boolean delTodayRobConfig(Long configId) {
        boolean isSuccess = this.todayRobConfigDao.del(configId);
        this.robCategoryActivityRelationDao.deleteByActivityId(configId);
        return isSuccess;
    }

    @Override
    public Boolean statusChange(Long configId, Integer status) {
        return this.todayRobConfigDao.statusChange(configId, status);
    }

    @Override
    public List<TodayRobConfigDto> findSortTodayRobConfig(Integer offset, Integer pageSize) {
        List<TodayRobConfigDto> robs = this.todayRobConfigDao.findSortTodayRobConfig(offset, pageSize);
        LinkedList robAllDtos = Lists.newLinkedList();
        ArrayList robTopDtos = Lists.newArrayList();
        ArrayList robDtos = Lists.newArrayList();
        for (TodayRobConfigDto rob : robs) {
            if (rob.isOpenSwitch(TodayRobConfigDto.SWITCHES_TOP.intValue())) {
                robTopDtos.add(rob);
                continue;
            }
            robDtos.add(rob);
        }
        Collections.sort(robTopDtos, new Comparator<TodayRobConfigDto>(){

            @Override
            public int compare(TodayRobConfigDto o1, TodayRobConfigDto o2) {
                if (o1.getStickyTime().before(o2.getStickyTime())) {
                    return 1;
                }
                return -1;
            }
        });
        Collections.sort(robDtos, new Comparator<TodayRobConfigDto>(){

            @Override
            public int compare(TodayRobConfigDto o1, TodayRobConfigDto o2) {
                if (o1.getGmtCreate().before(o2.getGmtCreate())) {
                    return 1;
                }
                return -1;
            }
        });
        robAllDtos.addAll(robTopDtos);
        robAllDtos.addAll(robDtos);
        return robAllDtos;
    }

    @Override
    public Boolean updateStickyTime(Long id, Integer switches, Date stickyTime) {
        return this.todayRobConfigDao.updateStickyTime(id, switches, stickyTime);
    }

    @Override
    public Boolean updateVisitTime(Long id) {
        return this.todayRobConfigDao.updateVisitTime(id);
    }

    @Override
    public Boolean updateAllTopSwitches() {
        return this.todayRobConfigDao.updateAllTopSwitches();
    }
}

