/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.api.enums.PushStatusEnum;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobSeckillConfigDao;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobSeckillDao;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TodayRobSeckillServiceImpl
implements TodayRobSeckillService {
    @Autowired
    private TodayRobSeckillDao todayRobSeckillDao;
    @Autowired
    private TodayRobSeckillConfigDao todayRobSeckillConfigDao;

    @Override
    public List<TodayRobSeckillConfigEntity> findSeckillConfigs(Long todayRobSeckillId) {
        return this.todayRobSeckillConfigDao.selectSeckillConfigs(todayRobSeckillId);
    }

    @Override
    public TodayRobSeckillEntity findSeckillById(Long todayRobSeckillId) {
        return this.todayRobSeckillDao.selectSeckillById(todayRobSeckillId);
    }

    @Override
    public List<TodayRobSeckillEntity> findTodayRobSeckillList(int pageNum, int pageSize) {
        return this.todayRobSeckillDao.selectTodayRobSeckillList(pageNum, pageSize);
    }

    @Override
    public Long findTodayRobSeckillCount() {
        return this.todayRobSeckillDao.selectTodayRobSeckillCount();
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean delTodayRobSeckill(long todayRobSeckillId) {
        this.todayRobSeckillDao.deleteTodayRobSeckill(todayRobSeckillId);
        ArrayList<Long> list = new ArrayList<Long>(1);
        list.add(todayRobSeckillId);
        this.todayRobSeckillConfigDao.deleteSeckillConfigBatch(list);
        return true;
    }

    @Override
    public Boolean enableTodayRobSeckill(long todayRobSeckillId, boolean enable) {
        return this.todayRobSeckillDao.updateTodayRobSeckill(todayRobSeckillId, enable);
    }

    @Override
    public TodayRobSeckillConfigEntity findPushedActivity(Long activityId) {
        return this.todayRobSeckillConfigDao.selectPushedActivity(activityId);
    }

    @Override
    public Boolean saveSeckillConfigBatch(List<TodayRobSeckillConfigEntity> insertParamList) {
        return this.todayRobSeckillConfigDao.insertSeckillConfigBatch(insertParamList);
    }

    @Override
    public Boolean updateSeckillConfigBatch(List<TodayRobSeckillConfigEntity> updateParamList) {
        return this.todayRobSeckillConfigDao.updateSeckillConfigBatch(updateParamList);
    }

    @Override
    public Boolean delSeckillConfigBatch(List<Long> delIds) {
        return this.todayRobSeckillConfigDao.deleteSeckillConfigBatch(delIds);
    }

    @Override
    public List<TodayRobSeckillConfigEntity> findSeckillConfigByIdss(List<Long> todayRobSeckillIds) {
        return this.todayRobSeckillConfigDao.selectSeckillConfigByIdss(todayRobSeckillIds);
    }

    @Override
    public Boolean saveSeckill(TodayRobSeckillEntity trc) {
        return this.todayRobSeckillDao.insertSeckill(trc);
    }

    @Override
    public Boolean updateSeckill(TodayRobSeckillEntity trc) {
        return this.todayRobSeckillDao.updateSeckill(trc);
    }

    @Override
    public void updatePushStatus(Long todayRobSeckillConfigId, PushStatusEnum pushStatus) {
        Date pushTime = null;
        if (pushStatus == PushStatusEnum.EXEC) {
            pushTime = new Date();
        }
        this.todayRobSeckillConfigDao.updatePushStatusAndTime(todayRobSeckillConfigId, pushStatus.getCode(), pushTime);
    }

    @Override
    public void disableActivityBeforeDate(Date date) {
        this.todayRobSeckillDao.disableActivityBeforeDate(date);
    }

    @Override
    public List<TodayRobSeckillConfigEntity> findUnsuccessPushList() {
        return this.todayRobSeckillConfigDao.findUnsuccessPushList();
    }

    @Override
    public TodayRobSeckillEntity findSeckillBeforeNow(String showEntrance) {
        List<TodayRobSeckillEntity> list = this.todayRobSeckillDao.selectSeckillBeforeTime(new Date(), 1, showEntrance);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<TodayRobSeckillEntity> findSeckillAfterNow(int limit, String showEntrance) {
        return this.todayRobSeckillDao.selectSeckillAfterTime(new Date(), limit, showEntrance);
    }

    @Override
    public List<Long> findEnableTodayRobSeckillIds() {
        return this.todayRobSeckillDao.findEnableTodayRobSeckillIds();
    }
}

