/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.sign.event.order.impl;

import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.tools.service.AppTradingLimitService;
import cn.com.duiba.activity.center.biz.tools.service.TodayActivityStatisticsService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityOrderSignImpl
implements InitializingBean {
    @Autowired
    private AppTradingLimitService appTradingLimit;
    @Autowired
    private TodayActivityStatisticsService todayActivityStatisticsService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registActivityOrdersEvent(new ActivityOrdersEvent.ActivityOrdersEventListener(){

            @Override
            public void onOrderSuccess(ActivityOrderDto order) {
                ActivityOrderSignImpl.this.appTradingLimit.addTrading(order.getAppId());
                ActivityOrderSignImpl.this.todayActivityStatisticsService.addTodayWinCount(order.getDuibaActivityId(), order.getActivityType(), order.getAppId());
            }

            @Override
            public void onOrderFail(ActivityOrderDto order) {
            }

            @Override
            public void onOrderCreate(ActivityOrderDto order) {
            }
        });
    }
}

