package cn.com.duiba.activity.common.center.api.remoteservice;

import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityGroupDTO;
import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityGroupDetailDTO;
import cn.com.duiba.activity.common.center.api.params.activitygroup.ActivityGroupParam;
import cn.com.duiba.activity.common.center.api.params.activitygroup.ActivityParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/03/12
 */
@AdvancedFeignClient
public interface RemoteActivityGroupService {
    /**
     * 获取活动组配置列表
     * @param pageNum 页码
     * @param pageSize 页面大小
     * @return PageInfo<ActivityGroupDTO>
     */
    PageInfo<ActivityGroupDTO> list(Integer pageNum, Integer pageSize);

    /**
     * 通过Id获取活动组配置
     * @param id id
     * @return ActivityGroupDTO
     */
    ActivityGroupDetailDTO findById(Long id);

    /**
     * 新建活动组配置
     * @param activityGroup 活动组基本配置
     * @param activityList 活动组中的活动列表，可以为空
     * @return 成功数
     */
    Long create(ActivityGroupParam activityGroup, List<ActivityParam> activityList);
    /**
     * 更新活动组配置
     * @param activityGroup 活动组基本配置
     * @param activityList 活动组中的活动列表，可以为空
     * @return 成功数
     */
    int update(ActivityGroupParam activityGroup, List<ActivityParam> activityList);

    /**
     * 软删除活动组配置
     * @param id 活动组Id
     * @return 成功数
     */
    int remove(Long id);
}
