package cn.com.duiba.activity.common.center.api.constants;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * 生成的key前缀为：ACTCOMMC_K001_
 * <p>
 * Created by zzy on 2017/2/9.
 */
public enum RedisKeyFactory {

    K001("用户信息"),
    K002("Abtest"),
    K003("活动弹层皮肤"),
    K004("活动皮肤"),
    K005("活动皮肤MD5"),
    K006("活动组"),
    K007("集卡助力规则"),
    K008("活动黑名单");

    private String description;

    private RedisKeyFactory(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    /**
     * activity-comm-center
     */
    private static final String SPACE = "ACTCOMMC";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


}
