package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.ConsumerShareCodeInfoDto;
import cn.com.duiba.activity.common.center.api.params.UserInviteParam;
import cn.com.duiba.activity.common.center.api.params.UserShareCodeParam;
import cn.com.duiba.activity.common.center.api.rsp.UserInviteResponseDto;
import cn.com.duiba.activity.common.center.api.rsp.sharecode.InviteResponseDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/04/09
 */
@AdvancedFeignClient
public interface RemoteUserShareCodeService {
    /**
     * 根据传入参数查找用户的分享码
     * @param userShareCodeParam 分享码参数
     * @return shareCode
     * @throws BizException bizException
     */
    ConsumerShareCodeInfoDto getUserShareCode(UserShareCodeParam userShareCodeParam) throws BizException;

    /**
     * 用户邀请
     * @param userInviteParam 邀请所需的参数
     * @return UserInviteResponseDto
     * @throws BizException bizException
     */
    InviteResponseDto userInvite(UserInviteParam userInviteParam)throws BizException;
}
