package cn.com.duiba.activity.common.center.api.remoteservice.sharecode.master;

import cn.com.duiba.activity.common.center.api.dto.sharecode.MasterDiscipleDto;
import cn.com.duiba.activity.common.center.api.params.MasterBonusParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/04/18
 */
@AdvancedFeignClient
public interface RemoteMasterDiscipleService {
    /**
     * 新增师徒关系
     * @param masterDiscipleDto 师徒关系参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(MasterDiscipleDto masterDiscipleDto) throws BizException;

    /**
     * 查询徒弟列表
     * @param masterId 师傅id
     * @return 师徒关系列表
     * @throws BizException bizException
     */
    List<MasterDiscipleDto> findDiscipleList(Long masterId) throws BizException;

    /**
     * 查询师傅（只有一个师傅）
     * @param discipleId 徒弟id
     * @return 师徒关系
     * @throws BizException bizException
     */
    MasterDiscipleDto findMaster(Long discipleId) throws BizException;

    /**
     * 师徒奖励发奖并生成师徒关系
     * @param masterBonusParam 师徒参数
     * @return 是否成功
     * @throws BizException bizException
     */
    Boolean presentBonus(MasterBonusParam masterBonusParam) throws BizException;
}
