package cn.com.duiba.activity.common.center.api.dto.happycode;

import cn.com.duiba.activity.common.center.api.dto.BaseDto;
import com.google.common.collect.ImmutableSet;

import java.util.Date;

/**
 * 开心码子订单
 * Created by hww on 2017/11/8 下午5:01.
 */
public class HappyCodeOrderDto extends BaseDto {

    private static final long serialVersionUID = 7145270360845482829L;

    /** 创建成功 */
    public static final int STATUS_READY = 0;

    /** 未中奖 */
    public static final int EXCHANGE_STATUS_NONE = 0;
    /** 待领取 */
    public static final int EXCHANGE_STATUS_WAIT = 1;
    /** 已领取 */
    public static final int EXCHANGE_STATUS_DONE = 2;
    /** 已过期 */
    public static final int EXCHANGE_STATUS_OVERDUE = 3;

    /** 所有来源类型 用于插入的订单时校验来源 */
    public static final ImmutableSet<Integer> ALL_ORIGIN =
            ImmutableSet.of(HappyCodeOrderDto.ORDER_ORIGIN_SIGN, HappyCodeOrderDto.ORDER_ORIGIN_PLUGIN);
    /** 来自于签到 */
    public static final int ORDER_ORIGIN_SIGN = 0;
    /** 来自于插件活动 */
    public static final int ORDER_ORIGIN_PLUGIN = 1;


    /** 主键id */
    private Long id;
    /** 应用id */
    private Long appId;
    /** 兑吧用户id */
    private Long consumerId;
    /** 开发者用户id */
    private String partnerUserId;
    /** 开心码 */
    private String happyCode;
    /** 期次id */
    private Long phaseId;
    /** 期次号 */
    private String phaseNumber;
    /** 奖项id */
    private Long optionId;
    /** 奖项类型 */
    private String optionType;
    /** 奖项名称 */
    private String optionName;
    /** 商品id */
    private Long itemId;
    /** 子订单状态 */
    private Integer orderStatus;
    /** 兑奖状态 */
    private Integer exchangeStatus;
    /** 订单来源 */
    private Integer origin;
    /** 删除 */
    private Integer deleted;
    /** 创建时间 */
    private Date gmtCreate;
    /** 更新时间 */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getHappyCode() {
        return happyCode;
    }

    public void setHappyCode(String happyCode) {
        this.happyCode = happyCode;
    }

    public Long getPhaseId() {
        return phaseId;
    }

    public void setPhaseId(Long phaseId) {
        this.phaseId = phaseId;
    }

    public String getPhaseNumber() {
        return phaseNumber;
    }

    public void setPhaseNumber(String phaseNumber) {
        this.phaseNumber = phaseNumber;
    }

    public Long getOptionId() {
        return optionId;
    }

    public void setOptionId(Long optionId) {
        this.optionId = optionId;
    }

    public String getOptionType() {
        return optionType;
    }

    public void setOptionType(String optionType) {
        this.optionType = optionType;
    }

    public String getOptionName() {
        return optionName;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getExchangeStatus() {
        return exchangeStatus;
    }

    public void setExchangeStatus(Integer exchangeStatus) {
        this.exchangeStatus = exchangeStatus;
    }

    public Integer getOrigin() {
        return origin;
    }

    public void setOrigin(Integer origin) {
        this.origin = origin;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
