package cn.com.duiba.activity.common.center.api.enums.consumeraccounts;

import com.google.common.collect.ImmutableSet;

/**
 * 账户类型
 * 最多支持100种
 */
public enum AccountTypeEnum {

    GLOBAL_REWARD("全局红包", 0),
    HAND_REWARD("手气红包", 1),
    PET_FEEDER("宠物养成饲养员账户",2),
    SIGN_VIRTUAL_CARD("签到补签虚拟卡", 3),
    EXP("经验账户", 4),
    FZ_GUESS("飞猪竞猜定制账户", 5),
    ALL_WALLET("全局钱包", 6),
    ;

    /**
     * 支持提现的账户类型
     */
    private static final ImmutableSet<AccountTypeEnum> ACCESS_DRAWS;

    static {
        ACCESS_DRAWS = ImmutableSet.of(GLOBAL_REWARD, HAND_REWARD, FZ_GUESS,ALL_WALLET);
    }

    /**
     * 判断当前账户类型是否支持提现
     * @param input
     * @return
     */
    public static boolean isAccessDraws(AccountTypeEnum input) {
        return ACCESS_DRAWS.contains(input);
    }

    AccountTypeEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    /** 描述 */
    private String desc;
    /** 类型码 */
    private Integer code;

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

}
