package cn.com.duiba.activity.common.center.api.remoteservice.activity;

import cn.com.duiba.activity.common.center.api.dto.activity.ActivityRemainingTimesDto;
import cn.com.duiba.activity.common.center.api.params.ActivityTimesParamNew;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author gey
 * @date 2018/04/19
 */
@AdvancedFeignClient
public interface RemoteActivityTimesNewService {

	/**
	 * 活动工具
	 * @author gey
	 * @date 2018/04/19
	 * 
	 * 活动剩余次数校验 参数
	 * 
	 * 1：支持分享加抽奖次数
	 * 2：支持流量组策略
	 * 3：支持活动组加次数
	 */
	ActivityRemainingTimesDto getRemainingTimes(ActivityTimesParamNew activityTimesParam) throws BizException;
	
    /**
     * 增加参与次数（限制次数和免费次数）
     * @param activityTimesParam 活动参数
     * 
     * 
     * @throws BizException bizException
     */
    void addJoinTimes(ActivityTimesParamNew activityTimesParam) throws BizException;
    
    
	/**
	 * 插件活动次数获取
	 * @author gey
	 * @date 2018/04/19
	 * 
	 * 活动剩余次数校验 参数
	 * 
	 * 1：支持分享加抽奖次数
	 * 2：支持流量组策略      暂时不支持
	 * 3：支持活动组加次数  暂时不支持
	 */
	ActivityRemainingTimesDto getPluginRemainingTimes(ActivityTimesParamNew activityTimesParam) throws BizException;
}
