package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.ConsumerShareCodeInfoDto;
import cn.com.duiba.activity.common.center.api.params.UserInviteParam;
import cn.com.duiba.activity.common.center.api.params.UserShareCodeParam;
import cn.com.duiba.activity.common.center.api.rsp.UserInviteResponseDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by sty on 2/2/18.
 */
@AdvancedFeignClient
public interface RemoteNewConsumerShareCodeService {
    /**
     * 根据传入参数查找用户的分享码
     * @param userShareCodeParam
     * @return
     */
     ConsumerShareCodeInfoDto getUserShareCode(UserShareCodeParam userShareCodeParam) throws BizException;

    /**
     * 用户邀请
     * @param userInviteParam
     * @return
     */
    UserInviteResponseDto userInvite(UserInviteParam userInviteParam)throws BizException;

    /**
     * 用户邀请，不判断是否已邀请过
     * @param userInviteParam
     * @return
     */
    UserInviteResponseDto userInviteWithoutCheckUsed(UserInviteParam userInviteParam) throws BizException;
}
