package cn.com.duiba.activity.common.center.api.utils.sharecode;

import org.apache.commons.lang.StringUtils;

/**
 * @author zhangruofan
 * @date 2018/04/10
 */
public class ShareCodeValidator {
    private ShareCodeValidator() {
        throw new IllegalStateException("ShareCodeValidator class");
    }
    /**
     * 判断是否是官方邀请码
     * 1.邀请码不为空
     * 2.邀请码不超过10位
     * 3.邀请码字母开头
     * @param shareCode 邀请码
     * @return true 是官方邀请码
     */
    public static boolean isOfficialShareCode(String shareCode) {
        return StringUtils.isNotBlank(shareCode)
                && shareCode.length() <= 10
                && Character.isLetter(shareCode.charAt(0));
    }

    /**
     * 判断是否是用户邀请码
     * 1.邀请码不为空
     * 2.邀请码数字开头
     * @param shareCode 邀请码
     * @return true 是用户邀请码
     */
    public static boolean isUserShareCode(String shareCode) {
        return StringUtils.isNotBlank(shareCode)
                && Character.isDigit(shareCode.charAt(0));
    }
}
