package cn.com.duiba.activity.common.center.api.remoteservice.floating;

import java.util.List;

import cn.com.duiba.activity.common.center.api.dto.floating.AbTestDto;
import cn.com.duiba.activity.common.center.api.dto.floating.FloatingLayerDto;
import cn.com.duiba.activity.common.center.api.dto.floating.FloatingLayerRelationDto;
import cn.com.duiba.activity.common.center.api.params.floating.FloatingLayerParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by gey on 2017/08/03.
 * 
 * 管理员端接口
 */
@AdvancedFeignClient
public interface RemoteActivityFloatingLayerBackendService {

	/**
	 * 查询皮肤信息列表
	 * 
	 * @param param
	 *
	 * @return
	 */
	public List<FloatingLayerDto> findFloatingLayerList(FloatingLayerParam param);
	
	/**
	 * 查询皮肤信息列表
	 * 
	 * @param floatingLayerId     
	 * @return
	 */
	public FloatingLayerDto findById(Long floatingLayerId) throws BizException;
	
	/**
	 * 报错或者更新  中奖弹层皮肤信息
	 * 
	 * @param dto
	 * @return  1 表示成功  0 失败
	 */
	public Integer saveOrUpdateFloatingLayer(FloatingLayerDto dto);
	
	/**
	 * 更新 皮肤关联关系
	 * 
	 * @param floatingLayerId  皮肤id
	 * @param relationTypes    类型
	 * @param relationIds      活动ids
	 * @param adminId           adminId
	 * 
	 * @return  1 表示成功  0 失败
	 */
	public Integer saveOrUpdateFloatingLayerRelation(Long floatingLayerId,List<String> relationTypes,List<Long> relationIds,Long adminId);
	

	/**
	 * 更新Abtest 信息
	 * 
	 * @param id  ABtest Id
	 * @param abTesType      测试类型
	 * @param relationType   活动类型
	 * @param relationId     活动id
	 * @param abTestIds      皮肤ids
	 * @param adminId
	 * @return  1 表示成功  0 失败
	 */
	public Integer saveOrUpdateAbTest(Long id,int abTesType, String relationType, Long relationId, List<Long> abTestIds ,Long adminId);
	
	/**
	 * 查询 abTest信息列表
	 *
	 * @return
	 */
	public List<AbTestDto> findAbTestList();

	/**
	 * 根据皮肤id查询所有关联纪录
     */
	public List<FloatingLayerRelationDto> findRelationByFloatingId(Long id);

	/**
	 * 根据获取所有皮肤数量
	 */
	public Integer findFloatingLayerCount();

	/**
	 * 根据id获取AbTest信息
	 */
	AbTestDto findAbTestById(Long id);

	/**
	 * 分页查询abRest
	 * @param param
	 */
	List<AbTestDto> findAbTestListPage(FloatingLayerParam param);

	/**
	 * 获取abTest总记录数
     */
	Integer findAbTestListCount();

	/**
	 * 修改abTest启用状态
	 */
	Integer changeState(Long id, boolean isOn);

	/**
	 * 删除abTest
	 */
	Integer deleteAbTest(Long id);

	/**
	 * 根据活动id,活动类型查询正在启用状态的abTest
	 */
	AbTestDto findAbTestOpen(AbTestDto queryDto);
}
