package cn.com.duiba.activity.common.center.api.dto.clrcard;

import cn.com.duiba.activity.common.center.api.enums.CLRewardRuleMatchEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import cn.com.duiba.activity.common.center.api.dto.clrcard.CLRewardDto.Entry;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ClassName:CLCardConfigDto<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/4/21  16:11
 * @since JDK 1.8
 **/
public class CLCardConfigDto implements Serializable{

    private static final long serialVersionUID = -2588430343441907015L;
    private Long id;
    /**
     * 集卡活动名称
     */
    private String clName;
    /**
     * 集卡规则集合（大于1000个字符），json结构，大概支持15个数据项配置
     */
    private List<CLRuleDto> rules;
    /**
     * 奖项配置（大于1000个字符），json结构，大概支持15个数据项配置
     */
    private List<CLRewardDto> rewards;
    /**
     * 是否后台自动发奖
     */
    private Boolean autoReward;
    /**
     * 单个用户 中奖限制，用于控制用户可中的奖项类型数量
     */
    private Integer rewardLimit;
    /**
     * 扩展字段，json类型，KV结构存储，所有KEY必须在这个DTO中定义为静态常量
     */
    private JSONObject extra;
    /**
     * 删除状态
     */
    private Boolean deleted;
    /**
     * 集卡类型
     * 0：发奖
     * 1：属性
     */
    private Integer clcardType =0;

    /**
     * 获取给定数据匹配的奖励等级,返回null表示未中奖
     *
     * @param entries
     * @return
     */
    public CLRewardDto getMatchGrade(List<Entry> entries) {
        if (CollectionUtils.isEmpty(entries)) {
            return null;
        }
        //顺序匹配奖项，匹配到即返回数据位置作为
        for (CLRewardDto dto : rewards) {
            if (matchValid(dto, entries)) {
                return dto;
            }
        }
        return null;
    }

    /**
     * 奖项匹配
     * @param reward
     * @param entries
     * @return
     */
    public boolean matchValid(CLRewardDto reward, List<Entry> entries){
        //全规则匹配
        if(CLRewardRuleMatchEnum.ALL_MATCH.equals(reward.getMatchType())){
            return allMatchValid(reward, entries);
            //随机集中卡校验
        }else if(CLRewardRuleMatchEnum.RANDOM_MATCH.equals(reward.getMatchType())) {
            return randomMatchValid(reward, entries);
        }
        return false;
    }

    private boolean randomMatchValid(CLRewardDto reward, List<Entry> entries) {
        Map<String, Integer> paramMap = new HashMap<>();
        for(Entry entry : entries){
            paramMap.put(entry.getKey(), entry.getVal());
        }
        int i =0;
        for(CLRuleDto dto :rules){
            Integer val = paramMap.get(String.valueOf(dto.getId()));
            if(val >0){
                i++;
                //判断是否满足 集齐任意卡总数
                if(i >= reward.getEntryCount()){
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 全匹配类型--中奖判断
     * @param reward
     * @param entries
     * @return
     */
    private boolean allMatchValid(CLRewardDto reward, List<Entry> entries) {
        Map<String, Integer> paramMap = new HashMap<>();
        for(Entry entry : entries){
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for(Entry rule : reward.getMatchs()){
            Integer val = paramMap.get(rule.getKey());
            if(val == null || val < rule.getVal()){
                return false;
            }
        }
        return true;
    }

    /**
     * 用卡片对换奖项
     * @param reward
     * @param entries
     */
    public void matchDeduct(CLRewardDto reward, List<Entry> entries) {
        //全规则匹配
        if(CLRewardRuleMatchEnum.ALL_MATCH.equals(reward.getMatchType())){
            allMatchDeduct(reward, entries);
            //随机集中卡校验
        }else if(CLRewardRuleMatchEnum.RANDOM_MATCH.equals(reward.getMatchType())) {
            randomMatchDeduct(entries);
        }
    }

    /**
     * 随机卡--用卡片对换奖项
     * @param entries
     */
    private void randomMatchDeduct(List<Entry> entries) {
        for(Entry rule : entries){
            rule.setVal(rule.getVal() - 1);
        }
    }

    /**
     * 全匹配类型--用卡片对换奖项
     * @param reward
     * @param entries
     */
    private void allMatchDeduct(CLRewardDto reward, List<Entry> entries) {
        Map<String, Integer> paramMap = new HashMap<>();
        for(Entry entry : reward.getMatchs()){
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for(Entry rule : entries){
            Integer val = paramMap.get(rule.getKey());
            if(val != null) {
                rule.setVal(rule.getVal() - val);
            }
        }
    }

    /**
     * 根据给定的集卡结果获取中奖奖项及奖项对应的数量
     * @param entries
     * @return K-V(CLRewardDto.getGradle,Num)
     */
    public Map<Integer, Integer> getMatchGradeMap(List<Entry> entries) {
        Map<Integer, Integer> result = new HashMap<>();
        List<Entry> entriesCopy = BeanUtils.copyList(entries, Entry.class);
        //顺序匹配奖项，匹配到即返回数据位置作为
        for (CLRewardDto dto : rewards) {
            int matchCount = 0;
            while(matchValid(dto, entriesCopy)){
                ++matchCount;
                matchDeduct(dto, entriesCopy);
            }
            result.put(dto.getGrade(), matchCount);
        }
        return result;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClName() {
        return clName;
    }

    public void setClName(String clName) {
        this.clName = clName;
    }

    public List<CLRuleDto> getRules() {
        return rules;
    }

    public void setRules(List<CLRuleDto> rules) {
        this.rules = rules;
    }

    public List<CLRewardDto> getRewards() {
        return rewards;
    }

    public void setRewards(List<CLRewardDto> rewards) {
        this.rewards = rewards;
    }

    public Boolean getAutoReward() {
        return autoReward;
    }

    public void setAutoReward(Boolean autoReward) {
        this.autoReward = autoReward;
    }

    public Integer getRewardLimit() {
        return rewardLimit;
    }

    public void setRewardLimit(Integer rewardLimit) {
        this.rewardLimit = rewardLimit;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Integer getClcardType() {
        return clcardType;
    }

    public void setClcardType(Integer clcardType) {
        this.clcardType = clcardType;
    }
}