package cn.com.duiba.activity.common.center.api.msg.consumeraccount;

import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountBizTypeEnum;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountSubTypeEnum;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;
import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 批量加账户金额请求消息体
 * 目前只支持统一业务的批处理
 * Created by hww on 2018/6/4 上午11:10.
 */
public class BatchIncreaseBalanceMsg implements Serializable {

    private static final long serialVersionUID = -1156992511919727883L;
    /** 应用id */
    private Long appId;
    /** 账单子类型 */
    private AccountSubTypeEnum subType;
    /** 业务类型 */
    private AccountBizTypeEnum bizType;
    /** 业务描述 */
    private String bizDescription;
    /** 每一个加金额的用户信息单元 */
    private List<BatchIncreaseBalanceUnitParam> unit;
    /** 备注 非必传*/
    private String memo;
    /** 账户类型 */
    private AccountTypeEnum accountType;
    /** 类型相关ID 可不填 默认为0 */
    private Long relId = 0L;
    /** 客户端ip 非必传*/
    private String clientIp;
    /** 客户端设备信息 非必传*/
    private String clientUa;
    /** 是否需要回调 */
    private boolean needCallBack;
    /** mq回调topic needCallBack == false时可不填 */
    private String callbackTopic;
    /** mq回调tag needCallBack == false时可不填 */
    private String callbackTag;
    /** mq回调key needCallBack == false时可不填 */
    private String callbackKey;
    /** 扩展参数 回调时原样返回 */
    private Map<String, String> transfer;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public AccountSubTypeEnum getSubType() {
        return subType;
    }

    public void setSubType(AccountSubTypeEnum subType) {
        this.subType = subType;
    }

    public AccountBizTypeEnum getBizType() {
        return bizType;
    }

    public void setBizType(AccountBizTypeEnum bizType) {
        this.bizType = bizType;
    }

    public String getBizDescription() {
        return bizDescription;
    }

    public void setBizDescription(String bizDescription) {
        this.bizDescription = bizDescription;
    }

    public List<BatchIncreaseBalanceUnitParam> getUnit() {
        return unit;
    }

    public void setUnit(List<BatchIncreaseBalanceUnitParam> unit) {
        this.unit = unit;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public AccountTypeEnum getAccountType() {
        return accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientUa() {
        return clientUa;
    }

    public void setClientUa(String clientUa) {
        this.clientUa = clientUa;
    }

    public boolean isNeedCallBack() {
        return needCallBack;
    }

    public void setNeedCallBack(boolean needCallBack) {
        this.needCallBack = needCallBack;
    }

    public String getCallbackTopic() {
        return callbackTopic;
    }

    public void setCallbackTopic(String callbackTopic) {
        this.callbackTopic = callbackTopic;
    }

    public String getCallbackTag() {
        return callbackTag;
    }

    public void setCallbackTag(String callbackTag) {
        this.callbackTag = callbackTag;
    }

    public String getCallbackKey() {
        return callbackKey;
    }

    public void setCallbackKey(String callbackKey) {
        this.callbackKey = callbackKey;
    }

    public Map<String, String> getTransfer() {
        return transfer;
    }

    public void setTransfer(Map<String, String> transfer) {
        this.transfer = transfer;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static BatchIncreaseBalanceMsg decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, BatchIncreaseBalanceMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(BatchIncreaseBalanceMsg msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
