package cn.com.duiba.activity.common.center.api.msg.consumeraccount;

import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountBizTypeEnum;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * 需要先调用isSuccess 判断是否处理成功
 * Created by hww on 2018/6/4 下午1:53.
 */
public class BatchIncreaseBalanceResultParam implements Serializable {

    private static final long serialVersionUID = 4813211420389572984L;

    /** 业务类型 */
    private AccountBizTypeEnum bizType;
    /** 业务id */
    private String bizId;
    /** 用户id */
    private Long consumerId;
    /** 若本次增加金额失败 此字段返回错误信息 */
    private String errorMsg;

    public AccountBizTypeEnum getBizType() {
        return bizType;
    }

    public void setBizType(AccountBizTypeEnum bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 是否处理成功
     * @return
     */
    public boolean isSuccess() {
        return StringUtils.isBlank(errorMsg);
    }

}
