/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.common.center.api.enums.consumeraccounts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum AccountTypeEnum {
    GLOBAL_REWARD("\u5168\u5c40\u7ea2\u5305", 0),
    HAND_REWARD("\u624b\u6c14\u7ea2\u5305", 1),
    PET_FEEDER("\u5ba0\u7269\u517b\u6210\u9972\u517b\u5458\u8d26\u6237", 2),
    SIGN_VIRTUAL_CARD("\u7b7e\u5230\u8865\u7b7e\u865a\u62df\u5361", 3),
    EXP("\u7ecf\u9a8c\u8d26\u6237", 4),
    FZ_GUESS("\u98de\u732a\u7ade\u731c\u5b9a\u5236\u8d26\u6237", 5),
    ALL_WALLET("\u5168\u5c40\u94b1\u5305", 6),
    AQY_WALLET("\u7231\u5947\u827a\u94b1\u5305", 7);

    private static final ImmutableSet<AccountTypeEnum> ACCESS_DRAWS;
    private static final ImmutableSet<AccountTypeEnum> EXPIRE_DRAWS;
    private static final ImmutableMap<Integer, AccountTypeEnum> ALL_MAP;
    private String desc;
    private Integer code;

    public static boolean isAccessDraws(AccountTypeEnum input) {
        return ACCESS_DRAWS.contains((Object)input);
    }

    public static boolean isExpireDraws(AccountTypeEnum input) {
        return EXPIRE_DRAWS.contains((Object)input);
    }

    public static AccountTypeEnum find(Integer code) {
        return (AccountTypeEnum)((Object)ALL_MAP.get((Object)code));
    }

    private AccountTypeEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    static {
        ACCESS_DRAWS = ImmutableSet.of((Object)((Object)GLOBAL_REWARD), (Object)((Object)HAND_REWARD), (Object)((Object)FZ_GUESS), (Object)((Object)ALL_WALLET), (Object)((Object)AQY_WALLET));
        EXPIRE_DRAWS = ImmutableSet.of((Object)((Object)ALL_WALLET));
        HashMap temp = Maps.newHashMap();
        for (AccountTypeEnum type : AccountTypeEnum.values()) {
            temp.put(type.getCode(), type);
        }
        ALL_MAP = ImmutableMap.copyOf((Map)temp);
    }
}

