package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.sharecode.InviteRuleDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/04/09
 */
@AdvancedFeignClient
public interface RemoteBackendInviteRuleService {
    /**
     * 保存邀请成功后的奖励规则
     * @param inviteRuleDto 邀请码规则参数
     * @return Long id
     * @throws BizException bizException
     */
    Long insert(InviteRuleDto inviteRuleDto) throws BizException;

    /**
     * 更新奖励规则
     * @param inviteRuleDto 邀请码规则参数
     * @return 是否更新成功
     * @throws BizException bizException
     */
    Integer update(InviteRuleDto inviteRuleDto) throws BizException;

    /**
     * 删除奖励规则
     * @param id id
     * @return 是否更新成功
     * @throws BizException bizException
     */
    Integer delete(Long id) throws BizException;

    /**
     * 获取奖励规则列表
     * @param inviteRuleSetId 规则集Id
     * @return List<InviteRuleDto>
     * @throws BizException bizException
     */
    List<InviteRuleDto> list(Long inviteRuleSetId) throws BizException;
}
