package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount;

import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsDto;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountAddAmountRequest;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountAddAmountResponse;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 用户账户服务
 * Created by hww on 2018/3/23 下午4:56.
 */
@AdvancedFeignClient
public interface RemoteConsumerAccountService {

    /**
     * 根据兑吧用户id和账号类型查询账户
     * 账号不存在时返回null
     * @param consumerId 兑吧用户id
     * @param accountType 账号类型 {@link AccountTypeEnum}
     * @return
     * @throws BizException
     */
    ConsumerAccountsDto find(Long consumerId, AccountTypeEnum accountType) throws BizException;

    /**
     * 根据兑吧用户id和账号类型查询账户
     * 若账户不存在，则创建新账户并返回
     * @param consumerId 兑吧用户id
     * @param appId 用户所属应用id 用于创建账户
     * @param partnerUserId 开发者用户id 用于创建账户
     * @param accountType 账号类型 {@link AccountTypeEnum}
     * @return
     * @throws BizException
     */
    ConsumerAccountsDto findOrInsert(Long consumerId, Long appId, String partnerUserId, AccountTypeEnum accountType) throws BizException;

    /**
     * 用户账户充值接口
     * 若账户不存在会先创建账户
     * @param request 账户充值接口入参列表 {@link AccountAddAmountRequest}
     * @return
     */
    AccountAddAmountResponse addAmount(AccountAddAmountRequest request) throws BizException;


}
