package cn.com.duiba.activity.common.center.api.remoteservice.flow;

import cn.com.duiba.activity.common.center.api.dto.flow.ActivityFlowRuleDto;
import cn.com.duiba.activity.common.center.api.dto.flow.FlowFeatureDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName:RemoteActivityFlowRuleService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 流量策略 配置   手机端接口
 * @date 创建时间：2018/4/18  14:26
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivityFlowRuleService {

    /**
     * 根据唯一索引查询配置
     *
     * @param appId
     * @param ruleType
     * @param activityType
     * @return
     */
    ActivityFlowRuleDto findByKey(Long appId, Integer ruleType, Integer activityType) throws BizException;


    /**
     * 修改流量配置
     * appId, ruleType, activityType必填
     * validRegions和validPeriod没有修改时传递旧值
     *
     * @param activityFlowRuleDto
     * @return
     */
    Boolean update(ActivityFlowRuleDto activityFlowRuleDto);

    /**
     * 批量更新
     *
     * @param activityFlowRuleDtos
     * @return
     */
    List<Boolean> updateList(List<ActivityFlowRuleDto> activityFlowRuleDtos);

    /**
     * 新增流量配置
     *
     * @param activityFlowRuleDto
     * @return
     */
    Long insert(ActivityFlowRuleDto activityFlowRuleDto);


    /**
     * 根据唯一索引查询配置
     *
     * @param appIds
     * @param ruleType
     * @param activityType
     * @return
     */
    Map<Long, ActivityFlowRuleDto> findListByKey(Set<Long> appIds, Integer ruleType, Integer activityType);

    /**
     * 根据规则查询符合条件的活动id列表
     *
     * @param flowFeatureDto
     * @return
     */
    List<Long> findListByRule(FlowFeatureDto flowFeatureDto);

    /**
     * 根据appId获取
     */
    ActivityFlowRuleDto findByAppId(Long appid) throws BizException;
}
