package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.sharecode.ShareCodeTimesConfigDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/04/18
 */
@AdvancedFeignClient
public interface RemoteBackendShareCodeTimesConfigService {
    /**
     * 新增分享码使用次数限制
     * @param shareCodeTimesConfigDto 配置参数
     * @return key
     */
    Long insert(ShareCodeTimesConfigDto shareCodeTimesConfigDto) throws BizException;

    /**
     * 更新配置
     * @param shareCodeTimesConfigDto 需要修改的配置
     * @return 影响行数
     */
    Integer update(ShareCodeTimesConfigDto shareCodeTimesConfigDto) throws BizException;

    /**
     * 通过活动查询分享码次数限制
     * @param activityId 活动id
     * @param activityType 活动类型
     * @return ShareCodeTimesConfigDto
     */
    ShareCodeTimesConfigDto findByActivity(Long activityId, String activityType) throws BizException;
}
