package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.sharecode.ShareCodeTimesConfigDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/04/18
 */
@AdvancedFeignClient
public interface RemoteShareCodeTimesConfigService {
    /**
     * 通过活动查询分享码次数限制
     * @param activityId 活动id
     * @param activityType 活动类型
     * @return ShareCodeTimesConfigDto
     * @throws BizException bizException
     */
    ShareCodeTimesConfigDto findByActivity(Long activityId, String activityType) throws BizException;

    /**
     * 新增次数限制配置
     * @param shareCodeTimesConfigDto 次数限制配置参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(ShareCodeTimesConfigDto shareCodeTimesConfigDto) throws BizException;

    /**
     * 更新次数限制配置参数
     * @param shareCodeTimesConfigDto 次数限制配置参数
     * @return 影响行数
     * @throws BizException bizException
     */
    Integer update(ShareCodeTimesConfigDto shareCodeTimesConfigDto) throws BizException;
}
