package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.sharecode.InvitedUserListDto;
import cn.com.duiba.activity.common.center.api.enums.ShareCodeActivityTypeEnum;
import cn.com.duiba.activity.common.center.api.params.UserInviteParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by zzy on 2018/7/4.
 */
@AdvancedFeignClient
public interface RemoteSimpleShareCodeService {
    /**
     * 根据分享码查询邀请的用户id列表
     *
     * @param shareCode             分享码
     * @param shareCodeActivityType 活动类型
     * @param activityId            活动id
     * @param count                 限制查询的数量
     * @return
     */
    InvitedUserListDto findInvitedConsumerIds(String shareCode, ShareCodeActivityTypeEnum shareCodeActivityType, Long activityId, int count) throws BizException;

    /**
     * 统计邀请的总数
     *
     * @param shareCode
     * @param shareCodeActivityType
     * @param activityId
     * @return
     */
    Integer countInvitedUser(String shareCode, ShareCodeActivityTypeEnum shareCodeActivityType, Long activityId);

    /**
     * 邀请用户
     *
     * @param userInviteParam 请求参数
     * @throws BizException 失败时会抛出异常，错误码标记对应错误场景
     */
    void inviteUser(UserInviteParam userInviteParam) throws BizException;
}
