package cn.com.duiba.activity.common.center.api.remoteservice.specify;

import cn.com.duiba.activity.common.center.api.dto.specify.ActivitySpecifyDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * ClassName:RemoteActivitySpecifyBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 活动定向接口 管理员端使用
 * @date 创建时间：2018/4/10  16:14
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivitySpecifyBackendService {

    /**
     *
     * insertSpecify:批量插入 定向数据 <br/>
     * 添加定向关系
     * @param list
     * @return
     * @since JDK 1.8
     */
    public Integer insertSpecify(List<ActivitySpecifyDto> list);

    /**
     *
     * findSpecifyById:根据id 查询定向信息 <br/>
     * 添加定向关系
     * @param id
     * @return
     * @since JDK 1.8
     */
    public ActivitySpecifyDto findSpecifyById(Long id);

    /**
     *
     * deleteSpecifyById:(删除定向关系). <br/>
     *
     * @param id
     * @return
     * @since JDK 1.8
     */
    public Integer deleteSpecifyById(Long id);

    /**
     *
     * findAllSpecifyByActivityIdAndType:(根据活动ID和type查询定向). <br/>
     *
     * @param hdToolId
     * @param activityType
     *
     * @return
     *
     * @since JDK 1.6
     */
    public List<ActivitySpecifyDto> findAllSpecifyByActivityIdAndType(Long hdToolId,String activityType);
}
