package cn.com.duiba.activity.common.center.api.remoteservice.config;

import cn.com.duiba.activity.common.center.api.dto.config.CLCardConfigGoodsRulesDto;
import cn.com.duiba.activity.common.center.api.params.config.CLCardGoodsRulesPageQueryParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: jiaozi
 * @date: 18/3/22 11:51
 * @description: 集卡助力奖品发放规则-后台接口
 */
@AdvancedFeignClient
public interface RemoteCLCardGoodsRulesBackendService {
    /**
     * 保存集卡配置
     * @param dto
     * @return
     */
    Long insert(CLCardConfigGoodsRulesDto dto);

    /**
     * 通过配置ID查询配置项详细信息
     * @param id
     * @return
     */
    CLCardConfigGoodsRulesDto findById(Long id) throws BizException;

    /**
     * 通过CLID查询未删除的配置项详细信息
     * @param clId
     * @return
     */
    List<CLCardConfigGoodsRulesDto> findByCLCardId(Long clId);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<CLCardConfigGoodsRulesDto> findByPage(CLCardGoodsRulesPageQueryParam param);

    /**
     * 统计
     * @param param
     * @return
     */
    Long count(CLCardGoodsRulesPageQueryParam param);

    /**
     * 通过ID更新数据
     * @param dto
     * @return dto.getId()不可为NULL
     */
    Boolean updateById(CLCardConfigGoodsRulesDto dto);

    /**
     * 删除ID对应配置
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

}
