package cn.com.duiba.activity.common.center.api.remoteservice.wallet;

import cn.com.duiba.activity.common.center.api.dto.wallet.RedAccPeriodDto;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccJoinValidParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccPeriodJoinParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccPeriodRelKeyParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by xiaoxuda on 2018/12/28.
 */
@AdvancedFeignClient
public interface RemoteRedAccPeriodService {
    /**
     * 0.业务已开启或者业务当前所加入的周期已开始，则不允许做任何变更
     * 1.已加入红包周期且与参数中红包周期ID一致，更新红包周期数据
     * 2.已加入红包周期且与参数中红包周期ID不一致，退出旧的红包周期，加入新的红包周期
     * 3.未加入红包周期且参数中包含周期ID，加入新的红包周期
     * 4.未加入红包周期且参数中不包含红包周期ID，创建新的红包周期
     * @param param
     * @return
     */
    Long joinPeriod(RedAccPeriodJoinParam param);

    /**
     * 验证是否可加入红包周期
     * @param param
     * @return
     */
    Boolean validJoinParam(RedAccJoinValidParam param);

    /**
     * 退出红包周期
     * 退出条件：周期未开始&&活动未开始
     * @param keyParam
     * @return
     */
    Boolean quitPeriod(RedAccPeriodRelKeyParam keyParam);

    /**
     * 根据唯一键同步红包周期关联活动开启状态，同步更新周期状态
     * @param keyParam
     * @return
     */
    Boolean openRelStatus(RedAccPeriodRelKeyParam keyParam);

    /**
     * 根据唯一键同步红包周期关联活动关闭状态，触发周期状态更新
     * @param keyParam
     * @return
     */
    Boolean closeRelStatus(RedAccPeriodRelKeyParam keyParam);

    /**
     * 开发者确认周期
     * @param periodId
     * @return
     */
    Boolean periodConfirm(Long periodId, Long appId);

    /**
     * 查询app维度下所有未开始的周期
     * @param appId
     * @return
     */
    List<RedAccPeriodDto> findWaitStartPeriodByAppId(Long appId);

    /**
     * 查询业务加入的周期
     * @param keyParam
     * @return
     */
    RedAccPeriodDto findByKey(RedAccPeriodRelKeyParam keyParam);

    /**
     * 查询开启状态的周期
     * @param appId
     * @return
     */
    RedAccPeriodDto findOpenPeriodByAppId(Long appId);
}
