package cn.com.duiba.activity.common.center.api.remoteservice.activitygroup;

import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityGroupDTO;
import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityGroupDetailRecordDTO;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/03/12
 */
@AdvancedFeignClient
public interface RemoteActivityGroupService {

    /**
     * 通过活动id获取活动组活动关系
     * @param activityId 活动id
     * @param activityType 活动类型
     * @return ActivityGroupDetailRecordDTO
     */
    ActivityGroupDetailRecordDTO findByActivityId(Long activityId, Integer activityType);

    /**
     * 通过活动组id获取活动组配置
     * @param activityGroupId 活动组配置Id
     * @return ActivityGroupDTO
     */
    ActivityGroupDTO findByGroupId(Long activityGroupId);
}
