package cn.com.duiba.activity.common.center.api.remoteservice.sharecode.master;

import cn.com.duiba.activity.common.center.api.dto.sharecode.BalanceDto;
import cn.com.duiba.activity.common.center.api.dto.sharecode.RedPacketRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.math.BigDecimal;

/**
 * @author zhangruofan
 * @date 2018/04/18
 */
@AdvancedFeignClient
public interface RemoteBalanceService {
    /**
     * 获取用户余额
     * @param consumerId 用户id
     * @return 余额
     * @throws BizException bizException
     */
    BalanceDto findByConsumerId(Long consumerId) throws BizException;

    /**
     * 用户提现
     * @param activityId 活动id
     * @param activityType 活动类型
     * @param consumerId 用户id
     * @param amount 提现金额不能为负数，精确到小数点后2位
     * @return Long 提现订单id
     * @throws BizException bizException
     */
    Long withDrawBalance(Long activityId, String activityType, Long consumerId, BigDecimal amount) throws BizException;

    /**
     * 发红包给用户
     * @param redPacketRecordDto 红包参数
     * @return 红包记录id
     * @throws BizException bizException
     */
    Long presentRedPacket(RedPacketRecordDto redPacketRecordDto) throws BizException;
}
