package cn.com.duiba.activity.common.center.api.remoteservice.wallet;

import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsDto;
import cn.com.duiba.activity.common.center.api.dto.wallet.RedAccPeriodDto;
import cn.com.duiba.activity.common.center.api.params.ConsumerAccInsertOuterParam;
import cn.com.duiba.activity.common.center.api.params.wallet.PeriodPageQueryParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccJoinValidParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccPeriodJoinParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccPeriodRelKeyParam;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccPeriodRechargeRequest;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountCashDrawsOuterRequest;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountCashDrawsResponse;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountModifyResponse;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by xiaoxuda on 2018/12/28.
 */
@AdvancedFeignClient
public interface RemoteRedAccPeriodService {
    /**
     * 0.业务已开启或者业务当前所加入的周期已开始，则不允许做任何变更
     * 1.已加入红包周期且与参数中红包周期ID一致，更新红包周期数据
     * 2.已加入红包周期且与参数中红包周期ID不一致，退出旧的红包周期，加入新的红包周期
     * 3.未加入红包周期且参数中包含周期ID，加入新的红包周期
     * 4.未加入红包周期且参数中不包含红包周期ID，创建新的红包周期
     * @param param
     * @return
     */
    Long joinPeriod(RedAccPeriodJoinParam param) throws BizException;

    /**
     * 验证是否可加入红包周期
     * 校验不通过则抛出异常，错误信息见异常
     * @param param
     * @return
     */
    Boolean validJoinParam(RedAccJoinValidParam param) throws BizException;

    /**
     * 退出红包周期
     * 退出条件：(周期未开始 || 活动未开始) && 周期未结束
     * @param keyParam
     * @return
     */
    Boolean quitPeriod(RedAccPeriodRelKeyParam keyParam) throws BizException;

    /**
     * 根据唯一键同步红包周期关联活动开启状态，同步更新周期状态
     * @param keyParam
     * @return
     */
    Boolean openRelStatus(RedAccPeriodRelKeyParam keyParam) throws BizException;

    /**
     * 根据唯一键同步红包周期关联活动关闭状态，触发周期状态更新
     * @param keyParam
     * @return
     */
    Boolean closeRelStatus(RedAccPeriodRelKeyParam keyParam) throws BizException;

    /**
     * 查询app维度下所有未开始的周期
     * @param appId
     * @return
     */
    List<RedAccPeriodDto> findWaitStartPeriodByAppId(Long appId);

    /**
     * 查询已结束的周期
     * @param appId
     * @return
     */
    List<RedAccPeriodDto> selectOverPeriodByAppId(Long appId);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<RedAccPeriodDto> pageSearch(PeriodPageQueryParam param);

    /**
     * 分页数量查询
     * @param param
     * @return
     */
    Integer pageSearchCount(PeriodPageQueryParam param);
    /**
     * 查询业务加入的周期,若周期是开启状态，则清退未开启起的关联活动
     * 不支持高并发调用
     * @param keyParam
     * @return
     */
    RedAccPeriodDto findByKey(RedAccPeriodRelKeyParam keyParam);

    /**
     * 查询开启状态的周期,若周期已开始会触发未开起活动的清退
     * @param appId
     * @return
     */
    RedAccPeriodDto findOpenPeriodByAppId(Long appId);

    /**
     * 总账户功能是否开启，判断条件：存在已到开始时间的周期
     * @param appId
     * @return
     */
    Boolean redPeriodHasOpen(Long appId);

    /**
     * 查询app下指定周期
     * @param appId
     * @param periodId
     * @return
     */
    RedAccPeriodDto findByAppIdAndPeriodId(Long appId, Long periodId);

    /**
     * 查询总账户业务用户账户信息,没有则新建
     * @return
     */
    ConsumerAccountsDto getRedAccCustomAccount(ConsumerAccInsertOuterParam param) throws BizException;

    /**
     * 总账户活动奖金入账
     * @param request
     * @return
     */
    AccountModifyResponse redAccActBonusRecharge(AccPeriodRechargeRequest request) throws BizException;

    /**
     * 总账户用户账户提现
     * @param request 账户提现接口入参列表 {@link AccountCashDrawsOuterRequest}
     * @return
     */
    AccountCashDrawsResponse redAccCustomCashDraws(AccountCashDrawsOuterRequest request);

    /**
     * 确定是否是标记用户
     * @param cid
     * @return
     */
    Boolean checkMarkUser(Long cid);
}
