package cn.com.duiba.activity.common.center.api.req.consumeraccounts;

import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountActionTypeEnum;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountBizTypeEnum;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountSubTypeEnum;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;
import cn.com.duiba.activity.common.center.api.req.CommonCenterBaseRequest;

/**
 * 用户账户充值请求类
 * Created by hww on 2018/3/23 下午2:11.
 */
public class AccountAmountModifyRequest extends CommonCenterBaseRequest {

    private static final long serialVersionUID = -5624792497219133928L;
    /** 应用id */
    private Long appId;
    /** 兑吧用户id */
    private Long consumerId;
    /** 开发者用户id*/
    private String partnerUserId;
    /** 账单子类型 ,needLog==false时可不填*/
    private AccountSubTypeEnum subType;
    /** 业务类型id  ,needLog==false时可不填*/
    private AccountBizTypeEnum bizType;
    /** 业务订单号  ,needLog==false时可不填*/
    private String bizId;
    /** 业务描述  ,needLog==false时可不填*/
    private String bizDescription;
    /** 备注 非必传*/
    private String memo;
    /** 金额 大于0 金额单位:分，其他为单个：个 */
    private Long changeMoney;
    /** 账户类型 */
    private AccountTypeEnum accountType;
    /**
     * 业务类型相关ID，非必传
     */
    private Long relId;
    /** 客户端ip 非必传*/
    private String clientIp;
    /** 客户端设备信息 非必传*/
    private String clientUa;
    /**
     * 操作类型
     */
    private AccountActionTypeEnum accActType;
    /**
     * 是否需要记录流水
     */
    private Boolean needLog;

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientUa() {
        if (clientUa != null && clientUa.length() > 255) {
            //字段超过255长度，截取255个字符，防止数据库字段超长无法插入
            return clientUa.substring(0, 255);
        }
        return clientUa;
    }

    public void setClientUa(String clientUa) {
        this.clientUa = clientUa;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public AccountSubTypeEnum getSubType() {
        return subType;
    }

    public void setSubType(AccountSubTypeEnum subType) {
        this.subType = subType;
    }

    public AccountBizTypeEnum getBizType() {
        return bizType;
    }

    public void setBizType(AccountBizTypeEnum bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getBizDescription() {
        return bizDescription;
    }

    public void setBizDescription(String bizDescription) {
        this.bizDescription = bizDescription;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getChangeMoney() {
        return changeMoney;
    }

    public void setChangeMoney(Long changeMoney) {
        this.changeMoney = changeMoney;
    }

    public AccountTypeEnum getAccountType() {
        return accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    public AccountActionTypeEnum getAccActType() {
        return accActType;
    }

    public void setAccActType(AccountActionTypeEnum accActType) {
        this.accActType = accActType;
    }

    public Boolean getNeedLog() {
        return needLog;
    }

    public void setNeedLog(Boolean needLog) {
        this.needLog = needLog;
    }
}
