package cn.com.duiba.activity.common.center.api.enums.share;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2019/3/13.
 */
public enum ShareRelTypeEnum {
    SIGN_FOR_NEW(1, "拉新签到"),

    ;
    private Integer code;
    private String desc;

    private static Map<Integer, ShareRelTypeEnum> codeMap = new HashMap<>();
    static{
        for(ShareRelTypeEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static ShareRelTypeEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    ShareRelTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
