package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount;

import java.util.List;

import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerExpAccountsDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerExpLogDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.ConsumerAddExpResParam;
import cn.com.duiba.api.bo.ConsumerExpChangeDto;

/**
 * 用户经验账户服务service
 * Created by qianjue on 2018/5/2.
 */
@AdvancedFeignClient
public interface RemoteConsumerExpAccountService {
	/**
	 * 查询当前用户的经验等级信息
	 * @param consumerId
	 * @param appId
	 * @return
	 */
	ConsumerExpAccountsDto findConsumerExpInfo(Long consumerId,Long appId) throws BizException;

	/**
	 * 变更当前用户的经验值
	 * 如果当前用户没有对应的账号,会重新创建新账号
	 * @param expChangeDto
	 * @param isCheck 是否校验  true已校验 false未校验
	 * @return
	 */
	Boolean  addConsumerExpApi(ConsumerExpChangeDto expChangeDto,Boolean isCheck) throws BizException;

	/**
	 * 批量加经验
	 * @param consumerExpChangeDtoList
	 * @param isCheck 是否校验  true已校验 false未校验
	 * @return
	 * @throws BizException
	 */
	ConsumerAddExpResParam batchAddConsumerExpApi(List<ConsumerExpChangeDto> consumerExpChangeDtoList,Boolean isCheck) throws Exception;

	/**
	 * 分页查询用户经验流水
	 * @param consumerId
	 * @param appId
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	ConsumerExpLogDto findConsumerExpLogList(Long consumerId, Long appId, Integer pageNo, Integer pageSize) throws BizException;

}
