package cn.com.duiba.activity.common.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2019/1/2.
 */
public enum WithdrawTimeRewardTypeEnum {
    FIXED(1, "固定赠送"),
    CONTINUE_VISIT(2, "连续访问赠送"),
    ;

    private static Map<Integer, WithdrawTimeRewardTypeEnum> codeMap = new HashMap<>();
    static {
        for(WithdrawTimeRewardTypeEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static WithdrawTimeRewardTypeEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    private Integer code;
    private String desc;

    WithdrawTimeRewardTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
