package cn.com.duiba.activity.common.center.api.msg.consumeraccount;

import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 批量加账户金额响应消息体
 * Created by hww on 2018/6/4 上午11:11.
 */
public class BatchIncreaseBalanceResultMsg implements Serializable {

    private static final long serialVersionUID = 7357316471857382521L;

    /** 响应结果 包含每一条订单的回执 */
    private List<BatchIncreaseBalanceResultParam> result;
    /** 扩展参数 原样返回 */
    private Map<String, String> transfer;
    /** 错误信息 */
    private String errorMsg;

    public List<BatchIncreaseBalanceResultParam> getResult() {
        return result;
    }

    public void setResult(List<BatchIncreaseBalanceResultParam> result) {
        this.result = result;
    }

    public Map<String, String> getTransfer() {
        return transfer;
    }

    public void setTransfer(Map<String, String> transfer) {
        this.transfer = transfer;
    }


    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 是否处理成功
     * @return
     */
    public boolean isSuccess() {
        return StringUtils.isBlank(errorMsg);
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static BatchIncreaseBalanceResultMsg decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, BatchIncreaseBalanceResultMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(BatchIncreaseBalanceResultMsg msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
