package cn.com.duiba.activity.common.center.api.remoteservice.reward;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.common.center.api.dto.reward.RewardPopupDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteRewardPopupService {
	
	/**
	 * 根据id 查询
	 * 
	 * @param id
	 * 
	 * 查询已配置的 7天红包
	 */
	RewardPopupDto findById(Long id);
	
	/**
	 * 根据id 查询
	 * 
	 * @param opId
	 * 
	 * 查询已配置的 7天红包
	 */
	RewardPopupDto findByOpId(Long opId);
	
	/**
	 * 根据appId 查询
	 * 
	 * @param appId
	 * 
	 * 查询已配置的 7天红包  未关闭的
	 */
	List<RewardPopupDto> findByAppID(Long appId);
	
	/**
	 * 新增或者更新7天红包
	 * 
	 * 
	 * @param dto
	 */
	Long saveOrUpdateRewardPopup(RewardPopupDto dto);
	
	
	/**
	 * 开启/关闭   删除   状态修改
	 * 
	 * 
	 * @param dto
	 */
	Boolean switshStatus(Long opId,Integer type,Boolean vaule);
	
	
	/**
	 * 根据appId 查询
	 * 
	 * @param appId
	 * 
	 * 查询已配置的 7天红包  未关闭的
	 */
	List<RewardPopupDto> findByAppIdForCms(Long appId);
	
	/**
	 * 校验周期
	 * 
	 * @param appId
	 * 
	 * 查询已配置的 7天红包  未关闭的
	 */
	Boolean checkPeriod(Long id,Long appId,Date periodStartTime,Date periodEndTime);
}
