package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount;

import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerCashDrawsRecordDto;
import cn.com.duiba.activity.common.center.api.dto.wallet.RedAccCustomDto;
import cn.com.duiba.activity.common.center.api.params.ConsumerAccInsertOuterParam;
import cn.com.duiba.activity.common.center.api.params.RedAccCustomRecordQueryParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccCustomQueryParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RedAccCustomSaveParam;
import cn.com.duiba.activity.common.center.api.params.wallet.RewardWithdrawTimeParam;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccRechargeRequest;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountCashDrawsOuterRequest;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountCashDrawsResponse;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountModifyResponse;
import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * 活动自定义红包账户接口
 * Created by xiaoxuda on 2019/1/18.
 */
@AdvancedFeignClient
public interface RemoteRedAccCustomService {
    /**
     * 创建或者更新账户配置
     * @param param
     * @return
     */
    Long createOrUpdateAcc(RedAccCustomSaveParam param) throws BizException;

    /**
     * 通过app与配置ID查询账户配置信息
     * @param id
     * @return
     */
    RedAccCustomDto findById(Long appId, Long id);

    /**
     * 通过唯一键查询
     * @param relType
     * @param relId
     * @return
     */
    RedAccCustomDto findByKey(Long appId, ActivityUniformityTypeEnum relType, Long relId);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<RedAccCustomDto> findByPage(RedAccCustomQueryParam param);

    /**
     * 数据统计
     * @param param
     * @return
     */
    Integer findByPageCount(RedAccCustomQueryParam param);

    /**
     * 通过appId查询是否配置自定义账户,true是为存在记录
     * @param appId
     * @return
     */
    Boolean selectExistByAppId(Long appId);

    /**
     * 访问加提现次数
     * @return true:本次增加了体现次数，false:本次未增加提现次数
     */
    Boolean rewardWithdrawTime4Visit(RewardWithdrawTimeParam param);

    /**
     * 查询用户自定义账户提现机会剩余次数
     * @param param
     * @return
     */
    Long getRewardWithdrawTimes(RewardWithdrawTimeParam param);

    /**
     * 查询自定义账户业务用户账户信息,没有则新建
     * @return
     */
    ConsumerAccountsDto getRedAccCustomAccount(ConsumerAccInsertOuterParam param) throws BizException;

    /**
     * 查询自定义账户业务用户账户信息,没有则新建
     * <p>
     * 账户余额支持按照过期时间清零
     *
     * @param param 查询参数
     * @param expireTime 过期时间
     * @param relType 活动类型
     * @return 账户信息
     * @throws BizException
     */
    ConsumerAccountsDto getRedAccCustomAccountWithExpire(ConsumerAccInsertOuterParam param, Date expireTime, ActivityUniformityTypeEnum relType) throws BizException;

    /**
     * 自定义账户活动奖金入账
     * @param request
     * @return
     */
    AccountModifyResponse redAccActBonusRecharge(AccRechargeRequest request) throws BizException;

    /**
     * 自定义账户活动奖金入账--（刮红包入账接口，预算不足时上层中奖算法限制用户不超过提现门槛，该层不做余额校验，提现接口余额校验）
     * @param request
     * @return
     */
    AccountModifyResponse redAccActBonusRechargeForScrapeRedPacket(AccRechargeRequest request) throws BizException;

    /**
     * 自定义账户用户账户提现
     * @param request 账户提现接口入参列表 {@link AccountCashDrawsOuterRequest}
     * @return
     */
    AccountCashDrawsResponse redAccCustomCashDraws(AccountCashDrawsOuterRequest request);

    /**
     * 自定义账户提现信息查询
     * @param query
     * @return
     */
    List<ConsumerCashDrawsRecordDto> selectRedAccCustomRecord(RedAccCustomRecordQueryParam query);

    /**
     *  通过唯一键删除
     * @param appId
     * @param relType
     * @param relId
     * @return
     */
    Boolean removeRedAccCustomByKey(Long appId, ActivityUniformityTypeEnum relType, Long relId);

    /**
     * 自定义账户提现记录统计
     * @param query
     * @return
     */
    Integer countRedAccCustomRecord(RedAccCustomRecordQueryParam query);

    /**
     * 自定义账户提现记录统计（按用户统计）
     * @param query
     * @return
     */
    Long countRedAccCustomCashDraw4Consumer(RedAccCustomRecordQueryParam query);

    /**
     * 自定义账户提现金额统计
     * @param query
     * @return
     */
    Long countRedAccCustomCashDraw(RedAccCustomRecordQueryParam query);

    /**
     * 自定义账户用户虚拟货币提现前的基础校验流程
     * @param request 账户提现接口入参列表 {@link AccountCashDrawsOuterRequest}
     * @return
     */
    void verifyForVirtual(AccountCashDrawsOuterRequest request) throws BizException;

    /**
     * 自定义账户用户账户提现 -- 虚拟货币
     * @param request 账户提现接口入参列表 {@link AccountCashDrawsOuterRequest}
     * @return
     */
    Long redAccCustomCashDraws4VirtualCurrency(AccountCashDrawsOuterRequest request) throws BizException;
}
