package cn.com.duiba.activity.common.center.api.remoteservice.asyntask;

import cn.com.duiba.activity.common.center.api.dto.asyntask.AsynTaskDto;
import cn.com.duiba.activity.common.center.api.enums.asyntask.AsynTaskTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * 异步任务数据服务
 * Created by xiaoxuda on 2019/2/21.
 */
@AdvancedFeignClient
public interface RemoteAsynTaskService {
    /**
     * 创建异步任务
     * @param task
     * @return 数据ID
     */
    Long insert(AsynTaskDto task);

    /**
     * 批量插入
     * @param list
     * @return
     */
    Integer batchInsert(List<AsynTaskDto> list);

    /**
     * 更新异步任务下次执行时间
     * @param taskId
     * @param nextTime
     * @return
     */
    Boolean updateNextTime(Long taskId, Date nextTime);

    /**
     * 删除异步任务
     * @param taskId
     * @return
     */
    Boolean deleteById(Long taskId);

    /**
     * 拉取特定待执行的异步任务
     * @return
     */
    List<AsynTaskDto> searhByType(AsynTaskTypeEnum taskType);
}
