package cn.com.duiba.activity.common.center.api.params;

import cn.com.duiba.activity.common.center.api.enums.ShareCodeActivityTypeEnum;

import java.io.Serializable;

/**
 * Created by sty on 2/2/18.
 */
public class UserShareCodeParam implements Serializable {

    private static final long serialVersionUID = -6270025806903447331L;
    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 活动类型
     */
    private ShareCodeActivityTypeEnum shareCodeActivityTypeEnum;
    /**
     * 活动id
     */
    private Long activityId;

    /**
     * appId
     */
    private Long appId;

    /**
     * 分享码订制后缀，在生成分享码时，会在原有逻辑生成的分享码后+ "_"+此后缀
     * 例如：分享码当日有效，后缀即可为当天的日志 yyyy-MM-dd
     * 同理分享码当月有效，后缀即可为当月的开始日期
     */
    private String shareCodeSuffix;


    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public ShareCodeActivityTypeEnum getShareCodeActivityTypeEnum() {
        return shareCodeActivityTypeEnum;
    }

    public void setShareCodeActivityTypeEnum(ShareCodeActivityTypeEnum shareCodeActivityTypeEnum) {
        this.shareCodeActivityTypeEnum = shareCodeActivityTypeEnum;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getActivityType(){
        ShareCodeActivityTypeEnum em = getShareCodeActivityTypeEnum();
        if(em==null){
            return null;
        }
        return em.getCode();
    }

    public String getShareCodeSuffix() {
        return shareCodeSuffix;
    }

    public void setShareCodeSuffix(String shareCodeSuffix) {
        this.shareCodeSuffix = shareCodeSuffix;
    }
}
