package cn.com.duiba.activity.common.center.api.rsp.userstate;

import cn.com.duiba.activity.common.center.api.dto.actrecord.ActUserStateRecordDto;

import java.io.Serializable;

public class MarkedWithLevelResponse implements Serializable {

    private static final long serialVersionUID = 4327939170875271696L;

    /** 标记是否成功 */
    private boolean success;
    /** 如果根据等级 替换了用户 此字段返回被替换的用户 */
    private ActUserStateRecordDto replacedConsumer;

    private MarkedWithLevelResponse(boolean success, ActUserStateRecordDto replacedConsumer) {
        this.success = success;
        this.replacedConsumer = replacedConsumer;
    }

    private MarkedWithLevelResponse() {
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public ActUserStateRecordDto getReplacedConsumer() {
        return replacedConsumer;
    }

    public void setReplacedConsumer(ActUserStateRecordDto replacedConsumer) {
        this.replacedConsumer = replacedConsumer;
    }

    public static MarkedWithLevelResponse fail() {
        return new MarkedWithLevelResponse();
    }

    public static MarkedWithLevelResponse success() {
        return new MarkedWithLevelResponse(true, null);
    }

    public static MarkedWithLevelResponse success(ActUserStateRecordDto replacedConsumer) {
        return new MarkedWithLevelResponse(true, replacedConsumer);
    }
}
