package cn.com.duiba.activity.common.center.api.dto.flow;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:ActivityFlowRuleDto<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/4/18  14:28
 * @since JDK 1.8
 **/
public class ActivityFlowRuleDto  implements Serializable {

    private static final long serialVersionUID = 3611742511522350751L;

    /**
     * 规则类型：特殊流量
     */
    public static final int RULE_TYPE_SPECIAL = 1;

    /**
     * 规则类型：其他流量
     */
    public static final int RULE_TYPE_OTHER = 2;

    /**
     * 人工干预商品区
     */
    public static final int ACTIVITY_TYPE_GOOD_AREA = 41;

    /**
     * 人工干预活动免费参与次数
     */
    public static final int ACTIVITY_TYPE_FREE_LIMIT = 42;

    /**
     * 人工干预福袋中奖概率
     */
    public static final int ACTIVITY_TYPE_LUCKY_PROBABILITY = 43;

    /**
     * 插件
     */
    public static final int ACTIVITY_TYPE_PLUGIN = 50;

    /**
     * 插件式抽奖工具
     */
    public static final int ACTIVITY_TYPE_PLUGINDRAW = 52;

    /**
     * 浮标活动区域配置
     */
    public static final int Activity_TYPE_FLOAT_THROW = 61;

    /**
     * 广告投放配置
     */
    public static final int ACTIVITY_TYPE_ADVER = 62;

    /**
     * 客服
     */
    public static final int ACTIVITY_TYPE_CUSTOMER_SERVICE = 100;

    /**
     * 代理模式判断标识：关闭
     */
    public static final int PROXY_FLAG_CLOSE = 0;

    /**
     * 代理模式判断标识：开启
     */
    public static final int PROXY_FLAG_OPEN = 1;
    /**
     * 主键
     */
    private Long id;
    /**
     * App id
     */
    private Long appId;
    /**
     * 规则类型：特殊流量1；其他流量2
     */
    private Integer ruleType;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 活动id列表，json数组
     */
    private String activityIds;

    /**
     * 代理流量校验标识，0不校验，1校验
     */
    private Integer proxyFlag = 0;

    /**
     * 生效地域
     */
    private String validRegions;

    /**
     * 生效时段
     */
    private String validPeriod;


    /**
     * 失效起始时间
     */
    private Date invalidSdate;

    /**
     * 失效结束时间
     */
    private Date invalidEdate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(String activityIds) {
        this.activityIds = activityIds;
    }

    public Integer getProxyFlag() {
        return proxyFlag;
    }

    public void setProxyFlag(Integer proxyFlag) {
        this.proxyFlag = proxyFlag;
    }

    public String getValidRegions() {
        return validRegions;
    }

    public void setValidRegions(String validRegions) {
        this.validRegions = validRegions;
    }

    public String getValidPeriod() {
        return validPeriod;
    }

    public void setValidPeriod(String validPeriod) {
        this.validPeriod = validPeriod;
    }

    public Date getInvalidSdate() {
        return invalidSdate;
    }

    public void setInvalidSdate(Date invalidSdate) {
        this.invalidSdate = invalidSdate;
    }

    public Date getInvalidEdate() {
        return invalidEdate;
    }

    public void setInvalidEdate(Date invalidEdate) {
        this.invalidEdate = invalidEdate;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ActivityFlowRuleDto{");
        sb.append("id=").append(id);
        sb.append(", appId=").append(appId);
        sb.append(", ruleType=").append(ruleType);
        sb.append(", activityType=").append(activityType);
        sb.append(", activityIds='").append(activityIds).append('\'');
        sb.append(", proxyFlag=").append(proxyFlag);
        sb.append(", validRegions='").append(validRegions).append('\'');
        sb.append(", validPeriod='").append(validPeriod).append('\'');
        sb.append(", invalidSdate=").append(invalidSdate);
        sb.append(", invalidEdate=").append(invalidEdate);
        sb.append('}');
        return sb.toString();
    }


    /**
     * 有效时间段存储模型
     */
    public static class Period implements Serializable {
        private static final long serialVersionUID = -4729576638478408710L;
        private String s;
        private String e;

        public void setS(String s) {
            this.s = s;
        }

        public void setE(String e) {
            this.e = e;
        }

        public String getE() {
            return e;
        }

        public String getS() {
            return s;
        }
    }
}
