package cn.com.duiba.activity.common.center.api.dto.actrecord;

import cn.com.duiba.activity.common.center.api.enums.ActUserStateEnum;

import java.io.Serializable;

/**
 * author zhanghuifeng
 * date 2019-03-20-18:21
 */
public class ActUserStateRecordDto implements Serializable {

    private static final long serialVersionUID = 3843048759935637609L;

    // 没有具体的含义 上游可以自己定义
    public static final int LEVEL_10 = 10;
    public static final int LEVEL_20 = 20;
    public static final int LEVEL_30 = 30;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型
     * @see cn.com.duiba.api.enums.ActivityUniformityTypeEnum
     */
    private Integer activityType;

    /**
     * 状态标识:1-打标状态，0-取标状态
     * @see ActUserStateEnum
     */
    private Integer state;

    /**
     * 扩展字段
     */
    private String extra;

    /**
     * 标记等级
     */
    private Integer markLevel;


    public Integer getMarkLevel() {
        return markLevel;
    }

    public void setMarkLevel(Integer markLevel) {
        this.markLevel = markLevel;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}
