package cn.com.duiba.activity.common.center.api.dto.share;

import cn.com.duiba.activity.common.center.api.enums.share.ShareRelTypeEnum;

import java.util.Date;
import java.util.Objects;

/**
 * Created by xiaoxuda on 2018/12/13.
 */
public class CommonShareConfDto implements java.io.Serializable {
	private static final long serialVersionUID = 1L;
	
	/**自增主键**/
	private Long id;
	
	/**标题**/
	private String title;
	
	/**副标题**/
	private String subTitle;
	
	/**分享图标**/
	private String icon;

	/**奖励配置版本，决定助力奖励与被助力奖励配置的数据结构**/
	private Integer rewardConfVersion;

	/**分享奖励配置,根据relType对应的业务解析**/
	private String rewardConf;
	
	/**助力者可得奖励配置，,根据relType对应的业务解析**/
	private String helperRewardConf;
	
	/**业务类型，1：拉新签到**/
	private ShareRelTypeEnum relType;
	
	/**业务ID**/
	private Long relId;

	/**
	 * 分享页回调地址，唤端时使用
	 */
	private String callbackUrl;
	
	/**记录创建时间**/
	private Date gmtCreate;
	
	/**记录修改时间**/
	private Date gmtModified;
	/**授权地址**/
	private String authorizeUrl;
	/**
	 * 微信公众号二维码
	 */
	private String wechatQrCode;


	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public Integer getRewardConfVersion() {
		return rewardConfVersion;
	}

	public void setRewardConfVersion(Integer rewardConfVersion) {
		this.rewardConfVersion = rewardConfVersion;
	}

	public String getRewardConf() {
		return rewardConf;
	}

	public void setRewardConf(String rewardConf) {
		this.rewardConf = rewardConf;
	}

	public String getHelperRewardConf() {
		return helperRewardConf;
	}

	public void setHelperRewardConf(String helperRewardConf) {
		this.helperRewardConf = helperRewardConf;
	}

	public ShareRelTypeEnum getRelType() {
		return relType;
	}

	public void setRelType(ShareRelTypeEnum relType) {
		this.relType = relType;
	}

	public Long getRelId() {
		return relId;
	}

	public void setRelId(Long relId) {
		this.relId = relId;
	}

	public String getCallbackUrl() {
		return callbackUrl;
	}

	public void setCallbackUrl(String callbackUrl) {
		this.callbackUrl = callbackUrl;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getWechatQrCode() {
		return wechatQrCode;
	}

	public void setWechatQrCode(String wechatQrCode) {
		this.wechatQrCode = wechatQrCode;
	}

	public String getAuthorizeUrl() {
		return authorizeUrl;
	}

	public void setAuthorizeUrl(String authorizeUrl) {
		this.authorizeUrl = authorizeUrl;
	}

	@Override
	public boolean equals(Object obj){
		if(null == obj || !(obj instanceof CommonShareConfDto)){
			return false;
		}
		CommonShareConfDto dto = (CommonShareConfDto)obj;
		return Objects.equals(this.id, dto.getId()) && Objects.equals(this.getCallbackUrl(), dto.getCallbackUrl())
				&& Objects.equals(this.getHelperRewardConf(), dto.getHelperRewardConf()) && Objects.equals(this.getIcon(), dto.getIcon())
				&& Objects.equals(this.getRelType(), dto.getRelType()) && Objects.equals(this.getRelId(), dto.getRelId())
				&& Objects.equals(this.getRewardConf(), dto.getRewardConf()) && Objects.equals(this.getSubTitle(), dto.getSubTitle())
				&& Objects.equals(this.getTitle(), dto.getTitle()) && Objects.equals(this.getRewardConfVersion(), dto.getRewardConfVersion());
	}
}

