package cn.com.duiba.activity.common.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: activity-comm-center
 * @description: 提现渠道枚举
 * @author: Simba
 * @create: 2019-03-13 09:56
 **/
public enum CurrencyTypeEnum {
    RMB(1, "人民币"),
    VIRTUAL_CURRENCY(2, "虚拟货币");

    private static Map<Integer, CurrencyTypeEnum> codeMap = new HashMap<>();

    static {
        for (CurrencyTypeEnum type : values()) {
            codeMap.put(type.getCode(), type);
        }
    }

    public static CurrencyTypeEnum getByCode(Integer code) {
        return codeMap.get(code);
    }

    private Integer code;
    private String desc;

    CurrencyTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}

