package cn.com.duiba.activity.common.center.api.remoteservice.sharecode.master;

import cn.com.duiba.activity.common.center.api.dto.sharecode.RedPacketRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/04/18
 */
@AdvancedFeignClient
public interface RemoteRedPacketRecordService {
    /**
     * 新增红包记录
     * @param redPacketRecordDto 红包记录参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(RedPacketRecordDto redPacketRecordDto) throws BizException;

    /**
     * 分页获取红包记录(一页固定20)
     * @param consumerId 用户id
     * @param pageNo 页码
     * @return PageInfo<RedPacketRecordDto>
     * @throws BizException bizException
     */
    List<RedPacketRecordDto> listByConsumerId(Long consumerId, Integer pageNo) throws BizException;

    /**
     * 获取用户红包个数
     * @param consumerId 用户id
     * @return 红包个数
     * @throws BizException bizException
     */
    Integer countByConsumerId(Long consumerId) throws BizException;
}
