package cn.com.duiba.activity.common.center.api.remoteservice.wechat;

import cn.com.duiba.activity.common.center.api.dto.wechat.WechatShareParamDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 目前提供jsticket和token
 * Created by sty on 2018/4/24.
 */
@AdvancedFeignClient
public interface RemoteWeixinService {
    /**
     * 获取access_token
     * @return
     */
    String getAccessToken(String wxAppId);

    /**
     * 获取jsticket
     * @return
     */
    String getJsApiTicket(String wxAppId);


    /**
     * 获取微信分享参数
     * @param shareUrl 分享链接
     * @param wxdebug debug模式
     * @return 分享参数
     */
    WechatShareParamDto getWechatShareParam(String shareUrl, Boolean wxdebug);


    /**
     * 苏宁微信分享定制
     * @param shareUrl 分享链接
     * @param wxdebug debug模式
     * @return 分享参数
     */
    WechatShareParamDto getWechatShareParamSuning(String shareUrl, Boolean wxdebug);

}
