package cn.com.duiba.activity.common.center.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2019/4/30 15:03
 */
public enum WxJsTicketHostEnum {
    /**
     * js接口 安全域名
     */
    ACTIVITY("activity.m.duiba.com.cn", WechatAccountInfo.WX_YUNYINGZSJ),
    ACTIVITY_1("activity-1.m.duiba.com.cn", WechatAccountInfo.WX_YUNYINGZSJ),
    ACTIVITY_2("activity-2.m.duiba.com.cn", WechatAccountInfo.WX_YUNYINGZSJ),

    DUIBA_MOBILE("m.duiba.com.cn", WechatAccountInfo.WX_QIHO),
    DUIBA_MOBILE_PRE("m.duibapre.com.cn", WechatAccountInfo.WX_QIHO),

    ACTIVITY_3("activity-3.m.duiba.com.cn", WechatAccountInfo.WX_DUIBAFAMILY),
    ACTIVITY_5("activity-5.m.duiba.com.cn", WechatAccountInfo.WX_DUIBAFAMILY),
    /**
     * 【重要】测试环境专用
     */
    ACTIVITY_TEST("activity.m.duibatest.com.cn", WechatAccountInfo.WX_DUIBA_TEST),
    ACTIVITY_7("activity-7.m.duiba.com.cn", WechatAccountInfo.WX_DUIBA_TEST),
    ACTIVITY_8("activity-8.m.duiba.com.cn", WechatAccountInfo.WX_DUIBA_TEST),
    ACTIVITY_SUNING("gameact.suning.com", WechatAccountInfo.WX_DUIBA_TEST),

//    ACTIVITY_7("activity-7.m.duiba.com.cn", WechatAccountInfo.WX_DUIBAFAMILY),
//    ACTIVITY_8("activity-8.m.duiba.com.cn", WechatAccountInfo.WX_DUIBAFAMILY),
//    ACTIVITY_SUNING("gameact.suning.com", WechatAccountInfo.WX_DUIBAFAMILY),

//    ACTIVITY_ESPORTS("55322.activity-1.m.duiba.com.cn", WechatAccountInfo.WX_KEKE),
//    ACTIVITY_WATSONS("49215.activity-1.m.duiba.com.cn", WechatAccountInfo.WX_KEKE),
//    ACTIVITY_ABC("66501.activity-1.m.duiba.com.cn", WechatAccountInfo.WX_KEKE),


    ACTIVITY_KJJ("activitykjj.m.duiba.com.cn", WechatAccountInfo.WX_DUIBA_KJJ),
    ACTIVITY_KEJIJI("57084.activity-1.m.duiba.com.cn", WechatAccountInfo.WX_DUIBA_KJJ),
    ;

    private String domain;

    private WechatAccountInfo wxAppInfo;

    WxJsTicketHostEnum(String domain, WechatAccountInfo wxAppInfo) {
        this.domain = domain;
        this.wxAppInfo = wxAppInfo;
    }

    private static final Map<String, WxJsTicketHostEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WxJsTicketHostEnum tmp : values()){
            ENUM_MAP.put(tmp.getDomain(), tmp);
        }
    }

    public static WxJsTicketHostEnum getByCode(String domain) {
        return ENUM_MAP.get(domain);
    }

    public String getDomain() {
        return domain;
    }

    public WechatAccountInfo getWxAppInfo() {
        return wxAppInfo;
    }
}
