package cn.com.duiba.activity.common.center.api.remoteservice.black;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * ClassName:RemoteDeveloperActivityBlackService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 手机端黑名单校验  暂时迁移活动相关接口
 * @date 创建时间：2018/4/3  15:22
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteDeveloperActivityBlackService {

    /**
     *
     * 判断活动是否在黑名单中
     *
     * @param activityId
     * @param activityType
     * @param developerId
     *
     * @return
     * @since JDK 1.8
     */
    Boolean isExistBlackByActivityIdAndActivityTypeAndDeveloperId(Long activityId, Integer activityType,Long developerId) throws BizException;

    /**
     *
     * 黑名单定向校验
     *
     * @param activityId
     * @param activityType
     * @param developerId
     * @param appId
     * @param black
     * @param specify
     *
     * @return
     * @since JDK 1.8
     */
    Boolean isExistBlackAndSpecifyByActivityIdAndActivityType(Long activityId, Integer activityType,Long developerId, Long appId,Boolean black,Boolean specify) throws BizException;

    /**
     * 根据活动id,开发者id和活动类型查询加入黑名单的活动id列表
     * @param developerId
     * @param activityType
     * @return
     * @throws BizException
     */
    List<Long> filterBlackList(List<Long> activityList, Long developerId, Integer activityType);

    /**
     * 开发者id和活动类型查询加入黑名单的活动id列表
     * @param developerId
     * @param activityType
     * @return
     */
    List<Long> findActIdsByActTypeAndDeveloperId(Long developerId, Integer activityType);

}