package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount;

import cn.com.duiba.activity.common.center.api.dto.ConsumerAccountUniquenessKeyDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountWithLogsDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsLogDto;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountBizTypeEnum;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;
import cn.com.duiba.activity.common.center.api.params.ConsumerAccountInsertParam;
import cn.com.duiba.activity.common.center.api.params.account.AccPageSearchParam;
import cn.com.duiba.activity.common.center.api.params.wallet.DateRangeWalletAccountParam;
import cn.com.duiba.activity.common.center.api.params.wallet.PaginationDateRangeWalletAccountParam;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountAddAmountRequest;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountAmountModifyRequest;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountAddAmountResponse;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountModifyResponse;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 用户账户服务，不同业务需要做不同的
 * Created by hww on 2018/3/23 下午4:56.
 */
@AdvancedFeignClient
public interface RemoteConsumerAccountService {

    /**
     * 账户不再直接提供账户查询服务，请业务自己做包装
     * 根据兑吧用户id和账号类型查询账户
     * 账号不存在时返回null
     * @param uniKey
     * @return
     * @throws BizException
     */
    @Deprecated
    ConsumerAccountsDto find(Long consumerId, AccountTypeEnum accountType) throws BizException;
    ConsumerAccountsDto findByUniquenessKey(ConsumerAccountUniquenessKeyDto uniKey) throws BizException;

    /**
     * 根据兑吧用户id和账号类型查询账户
     * 若账户不存在，则创建新账户并返回
     * @param consumerId 兑吧用户id
     * @param appId 用户所属应用id 用于创建账户
     * @param partnerUserId 开发者用户id 用于创建账户
     * @param accountType 账号类型 {@link AccountTypeEnum}
     * @return
     * @throws BizException
     */
    @Deprecated
    ConsumerAccountsDto findOrInsert(Long consumerId, Long appId, String partnerUserId, AccountTypeEnum accountType) throws BizException;
    ConsumerAccountsDto searchOrInsert(ConsumerAccountInsertParam param) throws BizException;

    /**
     * 用户账户充值接口
     * 若账户不存在会先创建账户
     * @param request 账户充值接口入参列表 {@link AccountAddAmountRequest}
     * @return
     */
    @Deprecated
    AccountAddAmountResponse addAmount(AccountAddAmountRequest request) throws BizException;

    /**
     * 后续废止该接口，业务需要可以向账户owner提出开发请求
     * 用户账户充值接口
     * 若账户不存在会先创建账户
     * @param request 账户充值接口入参列表 {@link AccountAmountModifyRequest}
     * @return
     */
    @Deprecated
    AccountModifyResponse accountModify(AccountAmountModifyRequest request) throws BizException;

	/**
	 * 分页查询用户账户变更流水,废弃，不暴露accountId给业务方，请使用accLogPageSearch
	 * @param accountId
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	@Deprecated
	List<ConsumerAccountsLogDto> walletDetail(String accountId, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 后续废止该接口，业务需要可以向账户owner提出开发请求
     * 查询用户账户相关信息，用户一段时间内的账户流水等信息
     * @param paginationDateRangeWalletAccountParam
     * @return
     */
    @Deprecated
	ConsumerAccountWithLogsDto getConsumerAccountWithDateRangeWalletDetail(PaginationDateRangeWalletAccountParam paginationDateRangeWalletAccountParam);

    /**
     * 获取用户账户一段时间内获取的金额总数（排除提现返还相关）
     * @param dateRangeWalletAccountParam
     * @return
     */
	Long getDateRangeInAmount(DateRangeWalletAccountParam dateRangeWalletAccountParam);

    /**
     * 根据用户id、账户类型、业务类型查询当天的收入
     * 只能用户全局账户，不支持账户id上带有活动id的账户类型
     * 方法会返回null
     */
	Long selectDailyRecord(Long consumerId, AccountTypeEnum accountType, AccountBizTypeEnum bizType);

    /**
     *  获取截止昨日账户余额(只计入收到的红包总额)
     */
    Long selectYesterdayAccount(Long consumerId, Long appId);

    /**
     *
     * 账户不再直接提供对外的单个服务，所有业务相关经过对应业务包装，
     **/

    /**
     * 账户变更记录分页查询
     * @return
     */
    List<ConsumerAccountsLogDto> accLogPageSearch(AccPageSearchParam param);

    /**
     * 账户变更记录统计
     * @param param
     * @return
     */
    Integer accLogPageSearchCount(AccPageSearchParam param);
}
