package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount.custom;

import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsDto;
import cn.com.duiba.activity.common.center.api.params.ConsumerAccInsertOuterParam;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccRechargeRequest;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountCashDrawsOuterRequest;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountCashDrawsResponse;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountModifyResponse;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 猜红包账户服务
 * @date 2019/3/28 15:23
 */
@AdvancedFeignClient
public interface RemoteAccountForGuessRedPacketService {
    /**
     * 查询或创建账户
     * @param param
     * @return
     * @throws BizException
     */
    ConsumerAccountsDto findOrCreateAccount(ConsumerAccInsertOuterParam param) throws BizException;

    /**
     * 充值
     * @param request
     * @return
     * @throws BizException
     */
    AccountModifyResponse recharge(AccRechargeRequest request) throws BizException;

    /**
     * 提现
     * @param request
     * @return
     */
    AccountCashDrawsResponse cashDraw(AccountCashDrawsOuterRequest request);
}
